﻿using System;
using System.Collections.Generic;
using System.Text;

using KeePass.Plugins;
using KeePass.UI;

using KeePassLib.Utility;

namespace CustomSecureTextBox
{
	public sealed class CustomSecureTextBoxExt : Plugin
	{
		public override bool Initialize(IPluginHost host)
		{
			TypeOverridePool.Register(typeof(SecureTextBoxEx),
				CreateCustomInstance);

			return true;
		}

		public override void Terminate()
		{
			TypeOverridePool.Unregister(typeof(SecureTextBoxEx));
		}

		private static object CreateCustomInstance()
		{
			return new NewSecureTextBox();
		}
	}
}
