﻿/*
  KeeOldFormatExport Plugin
  Copyright (C) 2012-2019 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

using KeePass;
using KeePass.Resources;

using KeePassLib;
using KeePassLib.Interfaces;
using KeePassLib.Utility;

using FileFormatProvider = KeePass.DataExchange.FileFormatProvider;
using PwExportInfo = KeePass.DataExchange.PwExportInfo;

namespace KeeOldFormatExport.V219
{
	public sealed class V219Provider : FileFormatProvider
	{
		public override bool SupportsImport { get { return false; } }
		public override bool SupportsExport { get { return true; } }

		public override string FormatName { get { return "KeePass KDBX (2.19)"; } }
		public override string DefaultExtension { get { return "kdbx"; } }
		public override string ApplicationGroup { get { return KeeOldFormatExportExt.GroupName; } }

		public override bool SupportsUuids { get { return true; } }
		public override bool RequiresKey { get { return true; } }

		public override Image SmallIcon
		{
			get
			{
				try
				{
					return Program.MainForm.ClientIcons.Images[
						(int)PwIcon.PaperLocked];
				}
				catch(Exception) { Debug.Assert(false); }
				return base.SmallIcon;
			}
		}

		public override bool Export(PwExportInfo pwExportInfo, Stream sOutput,
			IStatusLogger slLogger)
		{
			Kdb4File kdbx = new Kdb4File(pwExportInfo.ContextDatabase);
			kdbx.Save(sOutput, pwExportInfo.DataGroup, Kdb4Format.Default, slLogger);
			return true;
		}
	}
}
