﻿/*
  KeeOldFormatExport Plugin
  Copyright (C) 2012-2019 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

using KeePass.Plugins;

using KeeOldFormatExport.V123;
using KeeOldFormatExport.V219;

namespace KeeOldFormatExport
{
	public sealed class KeeOldFormatExportExt : Plugin
	{
		internal const string GroupName = "KeeOldFormatExport Plugin";

		private IPluginHost m_host = null;

		private V123Provider m_v123 = new V123Provider();
		private V219Provider m_v219 = new V219Provider();

		public override bool Initialize(IPluginHost host)
		{
			Terminate();

			m_host = host;
			if(m_host == null) return false;

			m_host.FileFormatPool.Add(m_v123);
			m_host.FileFormatPool.Add(m_v219);

			return true;
		}

		public override void Terminate()
		{
			if(m_host == null) return;

			m_host.FileFormatPool.Remove(m_v123);
			m_host.FileFormatPool.Remove(m_v219);

			m_host = null;
		}
	}
}
