﻿/*
  KeeAutoExec Plugin
  Copyright (C) 2009-2022 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.Text;

using KeePassLib;

namespace KeeAutoExec
{
	public sealed class AutoExecItem
	{
		private readonly PwEntry m_pe;
		public PwEntry Entry
		{
			get { return m_pe; }
		}

		private readonly PwDatabase m_pd;
		public PwDatabase Database
		{
			get { return m_pd; }
		}

		public bool Enabled = true;
		public bool Visible = true;

		public long Priority = 0;

		public string IfDevice = null;

		public AutoExecItem(PwEntry pe, PwDatabase pdContext)
		{
			if(pe == null) throw new ArgumentNullException("pe");

			m_pe = pe;
			m_pd = pdContext;
		}
	}
}
