﻿/*
  IOProtocolExt Plugin
  Copyright (C) 2011-2023 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.Text;

namespace IOProtocolExt
{
	public static class IopDefs
	{
		public const string ProductName = "IOProtocolExt";

		// Deprecated:
		private const string OptPrefix = (IopDefs.ProductName + "_");
		public const string OptTimeout = (OptPrefix + "Timeout");
		public const string OptFtpsImplicit = (OptPrefix + "Ftps_Implicit");
		public const string OptFtpsExplicitSsl = (OptPrefix + "Ftps_ExplicitSsl");
		public const string OptFtpsExplicitTls = (OptPrefix + "Ftps_ExplicitTls");
	}

	public static class IopProps
	{
		public const string PrivateKey = "PrivateKey";
		public const string HostKey = "HostKey";

		public const string Certificate = "Certificate";

		public const string Passphrase = "Passphrase";

		public const string TlsSslImplicit = "TlsSsl_Implicit";
		public const string TlsSslExplicit = "TlsSsl_Explicit";

		public const string TimePreserve = "Time_Preserve";
		public const string WinScpRawSettings = "WinScp_RawSettings";
		public const string FritzBoxWorkaround = "FritzBoxWorkaround";
	}
}
