using KeePass.Plugins;
using KeePass.Forms;

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;



namespace DataBaseReorder
{
    /// <summary>
    /// This is the main plugin class. It must be named exactly
    /// like the namespace and must be derived from
    /// <c>KeePassPlugin</c>.
    /// </summary>
    public sealed class DataBaseReorderExt : Plugin
    {
        // The sample plugin remembers its host in this variable.
        private IPluginHost m_host = null;

        private ToolStripSeparator m_tsSeparator = null;
        private ToolStripMenuItem m_tsmiPopup = null;
        private ToolStripMenuItem m_tsmiReorder = null;
        private ToolStripMenuItem m_tsmiReorderSelectGroup = null;

        private void _ReOrderGroup(KeePassLib.PwGroup OrderGroup,bool Recursive)
        {
            if (OrderGroup != null)
            {
                System.Collections.Generic.SortedDictionary<string, KeePassLib.PwGroup> list;
                list = new SortedDictionary<string, KeePassLib.PwGroup>();
                foreach (KeePassLib.PwGroup gp in OrderGroup.Groups)
                {
                    list.Add(gp.Name +  " " + Guid.NewGuid().ToString(), gp);
                    if (Recursive)
                    {
                        _ReOrderGroup(gp,true );
                    }
                }
                if (list.Count > 0)
                {
                    KeePassLib.PwGroup[] OrderArray = new KeePassLib.PwGroup[list.Count];
                    list.Values.CopyTo(OrderArray, 0);
                    OrderGroup.Groups.MoveTopBottom(OrderArray, true);
                }
                
            }
            else
            {
                MessageBox.Show("Empty group");
            }
        }

        /// <summary>
        /// The <c>Initialize</c> function is called by KeePass when
        /// you should initialize your plugin (create menu items, etc.).
        /// </summary>
        /// <param name="host">Plugin host interface. By using this
        /// interface, you can access the KeePass main window and the
        /// currently opened database.</param>
        /// <returns>You must return <c>true</c> in order to signal
        /// successful initialization. If you return <c>false</c>,
        /// KeePass unloads your plugin (without calling the
        /// <c>Terminate</c> function of your plugin).</returns>
        public override bool Initialize(IPluginHost host)
        {
            Debug.Assert(host != null);
            if (host == null) return false;
            m_host = host;


            // Get a reference to the 'Tools' menu item container
            ToolStripItemCollection tsMenu = m_host.MainWindow.ToolsMenu.DropDownItems;

            // Add a separator at the bottom
           // m_tsSeparator = new ToolStripSeparator();
            //tsMenu.Add(m_tsSeparator);

            // Add the popup menu item
            m_tsmiPopup = new ToolStripMenuItem();
            m_tsmiPopup.Text = "DB rearrange plug-in";
            tsMenu.Add(m_tsmiPopup);

            m_tsmiReorder = new ToolStripMenuItem();
            m_tsmiReorder.Text = "Rearrange all group";
            m_tsmiReorder.Click += OnMenuReorder;
            m_tsmiReorder.Enabled = true;
            m_tsmiPopup.DropDownItems.Add(m_tsmiReorder);

            m_tsmiReorderSelectGroup = new ToolStripMenuItem();
            m_tsmiReorderSelectGroup.Text = "Rearrange selected group child";
            m_tsmiReorderSelectGroup.Click += OnMenuReorderSelectGroup;
            m_tsmiReorderSelectGroup.Enabled = true;
            m_tsmiPopup.DropDownItems.Add(m_tsmiReorderSelectGroup);
            

            return true; // Initialization successful
        }

        /// <summary>
        /// The <c>Terminate</c> function is called by KeePass when
        /// you should free all resources, close open files/streams,
        /// etc. It is also recommended that you remove all your
        /// plugin menu items from the KeePass menu.
        /// </summary>
        public override void Terminate()
        {
            // Remove all of our menu items
            ToolStripItemCollection tsMenu = m_host.MainWindow.ToolsMenu.DropDownItems;
            tsMenu.Remove(m_tsSeparator);
            tsMenu.Remove(m_tsmiPopup);
            tsMenu.Remove(m_tsmiReorder);

        }



        private void OnMenuReorder(object sender, EventArgs e)
        {
            _ReOrderGroup(m_host.Database.RootGroup,true );
            m_host.MainWindow.UpdateUI(false, null, true, m_host.Database.RootGroup,
            true, null, true);
        }

        private void OnMenuReorderSelectGroup(object sender, EventArgs e)
        {
           KeePassLib.PwGroup pgSelect = null;

           if (m_host.Database.LastSelectedGroup != KeePassLib.PwUuid.Zero)
            {
                pgSelect = m_host.Database.RootGroup.FindGroup(m_host.Database.LastSelectedGroup, true);
                _ReOrderGroup(pgSelect, true);
                m_host.MainWindow.UpdateUI(false, null, true, m_host.Database.RootGroup,
                true, null, true);
            }

        }

    }
}
