﻿/*
  KeePass Password Safe - The Open-Source Password Manager
  Copyright (C) 2003-2009 Dominik Reichl <dominik.reichl@t-online.de>
  
  CodeWallet3ImportPlugin - Plugin for importing CodeWallet 3 files
  Copyright (C) 2009 Sebastian Baumhekel <sebasbaumh@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using KeePass.Plugins;

namespace CodeWallet3ImportPlugin
{
	public sealed class CodeWallet3ImportPluginExt : Plugin
	{
		private IPluginHost phHost = null;

		public override bool Initialize(IPluginHost host)
		{
			phHost = host;
			//just add the new file format to the pool
			phHost.FileFormatPool.Add(new CodeWalletTxt300());
			return true;
		}
	}
}
