﻿/*
  ArcFourCipher - KeePass Plugin
  Copyright (C) 2006-2024 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.IO;
using System.Security.Cryptography;
using System.Text;

using KeePassLib;
using KeePassLib.Cryptography.Cipher;

namespace ArcFourCipher
{
	internal sealed class ArcFourEngine : ICipherEngine2
	{
		private static readonly PwUuid g_pu = new PwUuid(new byte[] {
			0x04, 0xB2, 0x1B, 0x90, 0x3B, 0x39, 0x43, 0x24,
			0x9E, 0x7D, 0x8F, 0xE9, 0xA2, 0x1A, 0x34, 0xED });
		public PwUuid CipherUuid { get { return g_pu; } }

		public string DisplayName { get { return "ArcFour"; } }

		public int KeyLength { get { return 64; } }
		public int IVLength { get { return 16; } }

		public Stream EncryptStream(Stream s, byte[] pbKey, byte[] pbIV)
		{
			ArcFourTransform t = new ArcFourTransform(pbKey, pbIV);
			return new CryptoStream(s, t, CryptoStreamMode.Write);
		}

		public Stream DecryptStream(Stream s, byte[] pbKey, byte[] pbIV)
		{
			ArcFourTransform t = new ArcFourTransform(pbKey, pbIV);
			return new CryptoStream(s, t, CryptoStreamMode.Read);
		}
	}
}
