﻿/*
  ArcFourCipher - KeePass Plugin
  Copyright (C) 2006-2024 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

using KeePass.Plugins;

using KeePassLib.Utility;

namespace ArcFourCipher
{
	public sealed class ArcFourCipherExt : Plugin
	{
		public override bool Initialize(IPluginHost host)
		{
			if(host == null) return false;

			ArcFourEngine en = new ArcFourEngine();
			host.CipherPool.AddCipher(en);

#if DEBUG
			Test(en);
#endif
			return true;
		}

#if DEBUG
		private static void Test(ArcFourEngine en)
		{
			// Test vectors based on RFC 6229
			Test(en, "0102030405060708090A0B0C0D0E0F", "101112131415161718",
				"0000A0000000000000000000000C0000",
				"32CBAA1E9542C6B3B8B398ABC3BCF1D5");
			Test(en, "010203040506070809", "0A0B0C0D0E0F101112131415161718191A1B1C1D1E1F20",
				"0000000F200000000000000003000000",
				"625A1ABF2EE39A5327346BDDB31A9C18");
			Test(en, "1ADA31D5CF688221C10916", "3908EBE51DEBB46227C6CC8B37641910833222772A",
				"00000000000000050000000000009007",
				"9EA36C525531B885BA124334F57B9B77");
		}

		private static void Test(ArcFourEngine en, string strKey, string strIV,
			string strPT, string strCT)
		{
			byte[] pbKey = MemUtil.HexStringToByteArray(strKey);
			byte[] pbIV = MemUtil.HexStringToByteArray(strIV);
			byte[] pbPT = MemUtil.HexStringToByteArray(strPT);
			byte[] pbCT = MemUtil.HexStringToByteArray(strCT);

			using(MemoryStream msCT = new MemoryStream())
			{
				using(Stream sPT = en.EncryptStream(msCT, pbKey, pbIV))
				{
					MemUtil.Write(sPT, pbPT);
				}

				if(!MemUtil.ArraysEqual(msCT.ToArray(), pbCT))
					throw new Exception("Self-test failed!");
			}
		}
#endif
	}
}
