/*
  Copyright (c) 2003-2008, Dominik Reichl <dominik.reichl@t-online.de>
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  - Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  - Neither the name of ReichlSoft nor the names of its contributors may be
    used to endorse or promote products derived from this software without
    specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#include "TanUpgrade.h"
#include "../../KeePassLibCpp/PwManager.h"
#include "../../KeePassLibCpp/Util/TranslateEx.h"

#include "PwUtilCp.h"

#include <string>
#include <assert.h>

#include <boost/lexical_cast.hpp>

static KP_APP_INFO g_kpAppInfo;
static KP_PLUGIN_INFO g_kpInfo;

#define LOCAL_MENU_ITEM_COUNT 1
KP_MENU_ITEM g_menuItems[LOCAL_MENU_ITEM_COUNT];

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	UNREFERENCED_PARAMETER(hinstDLL);
	UNREFERENCED_PARAMETER(fdwReason);
	UNREFERENCED_PARAMETER(lpvReserved);

	return TRUE;
}

KP_EXP BOOL KP_API KeePluginInit(const KP_APP_INFO *pAppInfo, KP_PLUGIN_INFO *pPluginInfo)
{
	g_kpInfo.dwForAppVer = KPVD_VERSION;
	g_kpInfo.dwPluginVer = KPVD_VERSION;
	_tcscpy_s(g_kpInfo.tszPluginName, _countof(g_kpInfo.tszPluginName), KPP_PRODUCT_NAME);
	_tcscpy_s(g_kpInfo.tszAuthor, _countof(g_kpInfo.tszAuthor), _T("Dominik Reichl"));

	g_kpInfo.dwNumCommands = LOCAL_MENU_ITEM_COUNT;
	g_kpInfo.pMenuItems = (KP_MENU_ITEM *)g_menuItems;

	ZeroMemory(&g_menuItems, sizeof(KP_MENU_ITEM) * LOCAL_MENU_ITEM_COUNT);

	g_menuItems[0].lpCommandString = _T("Upgrade All TANs");
	g_menuItems[0].dwIcon = 11;

	// Make a copy of the app info structure
	memcpy(&g_kpAppInfo, pAppInfo, sizeof(KP_APP_INFO));

	// Fill the plugin info structure
	memcpy(pPluginInfo, &g_kpInfo, sizeof(KP_PLUGIN_INFO));

	return TRUE;
}

KP_EXP BOOL KP_API KeePluginExit(LPARAM lParamW, LPARAM lParamL)
{
	UNREFERENCED_PARAMETER(lParamW);
	UNREFERENCED_PARAMETER(lParamL);

	return TRUE;
}

void My_ProcessDirectCall(LPARAM lParamW, LPARAM lParamL)
{
	UNREFERENCED_PARAMETER(lParamL);

	if(lParamW != (LPARAM)g_menuItems[0].dwCommandID) return;
	if(KP_Query(KPQ_FILEOPEN, 0) != TRUE) return;

	CPwManager* pMgr = (CPwManager *)g_kpAppInfo.pPwMgr;
	HWND hWnd = g_kpAppInfo.hwndMain;
	DWORD dwUpgraded = 0;

	for(DWORD dwEntry = 0; dwEntry < pMgr->GetNumberOfEntries(); ++dwEntry)
	{
		PW_ENTRY* pe = pMgr->GetEntry(dwEntry);
		if(pe == NULL) { assert(false); continue; }

		if(_tcscmp(pe->pszTitle, PWS_TAN_ENTRY) != 0) continue;
		if(pe->pszUserName[0] != 0) continue;
		if(pe->pszURL[0] != 0) continue;

		if(IsTanIndex(pe->pszAdditional))
		{
			PW_ENTRY peNew;

			pMgr->UnlockEntryPassword(pe);
			if(Pu_MemAllocCopyEntry(pe, &peNew) == FALSE) { assert(false); }
			pMgr->LockEntryPassword(pe);

			TCHAR* lpIndex = peNew.pszAdditional;
			peNew.pszAdditional = peNew.pszUserName;
			peNew.pszUserName = lpIndex;

			if(KP_Call(KPC_EDIT_ENTRY, (LPARAM)dwEntry, (LPARAM)&peNew, 0) == 0)
			{
				assert(false);
			}

			Pu_MemFreeEntry(&peNew);

			++dwUpgraded;
		}
	}

	if(dwUpgraded > 0)
	{
		KP_Call(KPC_MODIFIED, TRUE, 0, 0);
		KP_Call(KPC_UPDATE_PASSWORDLIST, 0, 0, 0);
		KP_Call(KPC_UPDATE_TOOLBAR, 0, 0, 0);

		std::basic_string<TCHAR> str = _T("Successfully upgraded ");
		str += boost::lexical_cast<std::basic_string<TCHAR> >(dwUpgraded);
		str += _T(" TAN entries!");

		MessageBox(hWnd, str.c_str(), KPP_PRODUCT_NAME, MB_ICONINFORMATION | MB_OK);
	}
	else MessageBox(hWnd, _T("No upgradable TANs found!"), KPP_PRODUCT_NAME,
		MB_ICONINFORMATION | MB_OK);
}

KP_EXP BOOL KP_API KeePluginCall(DWORD dwCode, LPARAM lParamW, LPARAM lParamL)
{
	switch(dwCode)
	{
	case KPM_DIRECT_EXEC:
		My_ProcessDirectCall(lParamW, lParamL);
		break;

	case KPM_DIRECT_CONFIG:
		MessageBox(g_kpAppInfo.hwndMain, _T("This plugin doesn't have any options."),
			KPP_PRODUCT_NAME, MB_OK | MB_ICONINFORMATION);
		break;

	case KPM_PLUGIN_INFO:
		MessageBox(g_kpAppInfo.hwndMain, _T("Upgrade TANs of KeePass 1.10 and earlier for usage in KeePass 1.11 and higher."),
			KPP_PRODUCT_NAME, MB_OK | MB_ICONINFORMATION);
		break;

	case KPM_INIT_MENU_POPUP:
		if(KP_Query(KPQ_FILEOPEN, 0) == FALSE)
			g_menuItems[0].dwFlags |= KPMIF_DISABLED; // Disable menu item
		else
			g_menuItems[0].dwFlags &= ~KPMIF_DISABLED; // Enable menu item
		break;

	default:
		break;
	}

	return TRUE;
}

bool IsTanIndex(LPCTSTR lpString)
{
	if((lpString == NULL) || (lpString[0] == 0)) return false;

	DWORD i = 0;
	while(lpString[i] != 0)
	{
		if((lpString[i] < _T('0')) || (lpString[i] > _T('9'))) return false;

		++i;
	}

	return true;
}
