/*
  Copyright (c) 2008-2009, Dominik Reichl <dominik.reichl@t-online.de>
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  - Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef ___RMVDUP_PLUGIN_H___
#define ___RMVDUP_PLUGIN_H___

#include "../../KeePassLibCpp/SDK/KpSDK.h"

#define RD_PLUGIN_NAME _T("RmvDup Plugin")

#define RD_MENUITEMID_EXEC        0
#define RD_MENUITEMID_RMVEMPTYGROUPS 1

#define RD_MENUITEMS_COUNT        2

KP_EXPORT HRESULT KP_API KP_I_INITIALIZELIB_DECL(IKpUnknown* pAPI);
KP_EXPORT HRESULT KP_API KP_I_RELEASELIB_DECL(IKpUnknown* pAPI);

KP_EXPORT HRESULT KP_API KP_I_CREATEINSTANCE_DECL(REFIID riid, void** ppvObject,
	IKpUnknown* pAPI);

class CRmvDupPluginImpl : public IKpPlugin
{
public:
	CRmvDupPluginImpl();

	KP_DECL_IUNKNOWN;

	STDMETHODIMP_(BOOL) OnMessage(DWORD dwCode, LPARAM lParamW, LPARAM lParamL);

	STDMETHODIMP_(LPCTSTR) GetProperty(LPCTSTR lpName);
	STDMETHODIMP SetProperty(LPCTSTR lpName, LPCTSTR lpValue);

	STDMETHODIMP_(DWORD) GetMenuItemCount();
	STDMETHODIMP_(KP_MENU_ITEM*) GetMenuItems();

private:
	KP_DECL_STDREFIMPL;
};

void RemoveDuplicateEntriesEx();
void RemoveEmptyGroupsEx();

BOOL PwEntryEquals(IKpDatabase* pDB, PW_ENTRY* pe1, PW_ENTRY* pe2);
BOOL IsBackupPwEntry(IKpDatabase* pDB, PW_ENTRY* pe);

#endif // ___RMVDUP_PLUGIN_H___
