/*
  KeePass On-Screen Keyboard Plugin
  Copyright (C) 2005-2009 Dominik Reichl <dominik.reichl@t-online.de>
                     2011 Nikolaus Hammler <nikolaus@hammler.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ___OSK_PLUGIN_H___
#define ___OSK_PLUGIN_H___

#pragma once

#include "KeePassLibCpp/SDK/KpSDK.h"

#include "IKeyboard.h"
#include "StylusWatcher.h"

#define OSK_PLUGIN_NAME _T("OnScreenKeyboard Plugin")

#define OSK_MENUITEMID_EXEC		1
#define OSK_MENUITEMID_SETTINGS	3
#define OSK_MENUITEMID_HELP		4
#define OSK_MENUITEMCOUNT		6

KP_EXPORT HRESULT KP_API KP_I_INITIALIZELIB_DECL(IKpUnknown* pAPI);
KP_EXPORT HRESULT KP_API KP_I_RELEASELIB_DECL(IKpUnknown* pAPI);

KP_EXPORT HRESULT KP_API KP_I_CREATEINSTANCE_DECL(REFIID riid, void** ppvObject,
	IKpUnknown* pAPI);

class COSKPluginImpl : public IKpPlugin
{
public:
	COSKPluginImpl();
	virtual ~COSKPluginImpl();

	KP_DECL_IUNKNOWN;

	STDMETHODIMP_(BOOL) OnMessage(DWORD dwCode, LPARAM lParamW, LPARAM lParamL);

	STDMETHODIMP_(LPCTSTR) GetProperty(LPCTSTR lpName);
	STDMETHODIMP SetProperty(LPCTSTR lpName, LPCTSTR lpValue);

	STDMETHODIMP_(DWORD) GetMenuItemCount();
	STDMETHODIMP_(KP_MENU_ITEM*) GetMenuItems();

private:
	KP_DECL_STDREFIMPL;

	IKeyboard *m_keyboard;
	CStylusWatcher m_objStylusWatcher;

	KP_MENU_ITEM m_menuItems[OSK_MENUITEMCOUNT];
	int m_iUseKeyboard;
	BOOL m_bDetectTPC;

	void My_ProcessDirectCall(LPARAM lParamW, LPARAM lParamL);
	void ReCreateKeyboard();
	void ShowSettings();
	void LoadSettings();
	void SaveSettings();
};

#endif // ___OSK_PLUGIN_H___
