/*
  KeePass On-Screen Keyboard Plugin
  Copyright (C) 2005-2009 Dominik Reichl <dominik.reichl@t-online.de>
                     2011 Nikolaus Hammler <nikolaus@hammler.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "StdAfx.h"
#include "StylusWatcher.h"

static HHOOK g_hHook = NULL;
static CStylusWatcher::POINTERMODE g_ePointerMode = CStylusWatcher::POINTERMODE::Mouse;

CStylusWatcher::CStylusWatcher()
{
}

CStylusWatcher::~CStylusWatcher()
{
	UninstallHook();
}

void CStylusWatcher::InstallHook()
{
	if(!g_hHook) {
		HINSTANCE hMod = GetModuleHandle(0);
		g_hHook = SetWindowsHookEx(WH_MOUSE_LL, OnHook, hMod, 0);
	}
}

void CStylusWatcher::UninstallHook()
{
	if(g_hHook) {
		UnhookWindowsHookEx(g_hHook);
		g_hHook = 0;
	}
}

BOOL CStylusWatcher::IsTabletMode() const
{
	if(g_ePointerMode == POINTERMODE::Stylus)
		return TRUE;
	return FALSE;
}

LRESULT CALLBACK CStylusWatcher::OnHook(int nCode, WPARAM wParam, LPARAM lParam)
{
	if(nCode >= 0) {
		if(wParam == WM_LBUTTONDOWN || wParam == WM_MOUSEMOVE) {
			MSLLHOOKSTRUCT *lParamStruct = reinterpret_cast<MSLLHOOKSTRUCT*>(lParam);

			DWORD extra = lParamStruct->dwExtraInfo;
			g_ePointerMode = 
				((extra & 0xFFFFFF00) == 0xFF515700) ? 
				POINTERMODE::Stylus : POINTERMODE::Mouse;
		}
	}
	return CallNextHookEx(g_hHook, nCode, wParam, lParam);
}

