/*
  KeePass On-Screen Keyboard Plugin
  Copyright (C) 2005-2009 Dominik Reichl <dominik.reichl@t-online.de>
                     2011 Nikolaus Hammler <nikolaus@hammler.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

// This on-screen keyboard for KeePass is based on Randy More's
// on-screen keyboard implementation for pen computing and touchscreens.
// You can find his original sources and article here:
// http://www.codeproject.com/samples/onscreenkeyboard.asp

#if !defined(AFX_OSKDLG_H__F2D6AB7C_9C49_4B52_849D_C5ED97F14B74__INCLUDED_)
#define AFX_OSKDLG_H__F2D6AB7C_9C49_4B52_849D_C5ED97F14B74__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxtempl.h>
#include "Resource.h"

struct KEYDEF
{
	char cNormal;
	char cShifted;
	int cWidth;
};

/////////////////////////////////////////////////////////////////////////////

class COSKDlg : public CDialog
{
// Construction
public:
	COSKDlg(CWnd* pParent = NULL);

	void PumpMessages();
	void CleanUp();

	int nKeyWidth;
	int nKeyHeight;
	CTypedPtrList<CPtrList, KEYDEF*> cKeys;
	void AddKey(char chNormal, char chShifted, int nWidth);
	void CalcWidthHeight();
	void DrawKey(CDC *pDC, CRect& rc, KEYDEF *pKey, BOOL cHilight = FALSE);
	void SendKey(KEYDEF *pKeyDef);
	void ReleaseFocus();
	int DescribeKeyState();
	void DrawKeyboard();
	int cCurrentKeyState;
	HWND gFocus;

	//{{AFX_DATA(COSKDlg)
	enum { IDD = IDD_OSK_DLG };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(COSKDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(COSKDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_OSKDLG_H__F2D6AB7C_9C49_4B52_849D_C5ED97F14B74__INCLUDED_)
