/*
  KeePass On-Screen Keyboard Plugin
  Copyright (C) 2005-2009 Dominik Reichl <dominik.reichl@t-online.de>
                     2011 Nikolaus Hammler <nikolaus@hammler.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "StdAfx.h"
#include "KeyboardBuiltin.h"
#include "OSKDlg.h"

CKeyboardBuiltin::CKeyboardBuiltin()
	: m_hOSKThread(NULL)
	, m_bShowOSKDialog(FALSE)
	, m_bExecOSKThread(FALSE)
	, m_bForceUpdate(FALSE)
{
	DestroyOSKInstance();

	DWORD dwThreadID = 0;
	m_bExecOSKThread = TRUE;
	m_hOSKThread = CreateThread(NULL, 0, OSKThreadProc, this, 0, &dwThreadID);
}

CKeyboardBuiltin::~CKeyboardBuiltin()
{
	DestroyOSKInstance();
	Sleep(350); // Wait for thread termination
}

void CKeyboardBuiltin::OpenKeyboard()
{
	m_bShowOSKDialog = TRUE;
	m_bForceUpdate = TRUE;
}

void CKeyboardBuiltin::ShowKeyboard()
{
	OpenKeyboard();
}

void CKeyboardBuiltin::HideKeyboard()
{
	m_bShowOSKDialog = FALSE;
}

DWORD WINAPI CKeyboardBuiltin::OSKThreadProc(LPVOID lpParameter)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	CKeyboardBuiltin *me = static_cast<CKeyboardBuiltin*>(lpParameter);

	COSKDlg *pDlg = new COSKDlg();
	ASSERT(pDlg != NULL); if(pDlg == NULL) return 0;

	VERIFY(pDlg->Create(IDD_OSK_DLG, NULL));

	BOOL bLastShow = FALSE;

	while(me->m_bExecOSKThread == TRUE)
	{
		if((bLastShow != me->m_bShowOSKDialog) || (me->m_bForceUpdate == TRUE))
		{
			if(me->m_bShowOSKDialog == TRUE)
			{
				pDlg->ShowWindow(SW_SHOW);
				pDlg->SetWindowPos(&CWnd::wndTopMost, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
			}
			else pDlg->ShowWindow(SW_HIDE);

			bLastShow = me->m_bShowOSKDialog;
			me->m_bForceUpdate = FALSE;
		}

		pDlg->PumpMessages();
		Sleep(100);
	}

	pDlg->CleanUp();
	VERIFY(pDlg->DestroyWindow());
	delete pDlg; pDlg = NULL;

	// ExitThread(0);
	return 0;
}

void CKeyboardBuiltin::DestroyOSKInstance()
{
	if(m_hOSKThread != NULL)
	{
		m_bExecOSKThread = FALSE;

		CloseHandle(m_hOSKThread);
		m_hOSKThread = NULL;
	}
}

