/**
2007 Matias Bjarland - Iteego (mbjarland@yahoo.com)

Groovy script to convert passwords exported from 
FireFox into format readable by KeePass password safe

You can change, distribute, modify, trash this file to your hearts
content. 

Prerequisites: 
  Java 1.5 (J2SE)
                  available at http://java.sun.com/products/archive/index.html
  Groovy Scripting Language
                  available at http://groovy.codehaus.org/
  Password export/import extension to FireFox
                  available at https://addons.mozilla.org/firefox/2848/

Modification History

Date        Who        Bug            Description
______________________________________________________________________________
2007.Jan.19 mbjarland                 Initial Version

**/

import groovy.xml.MarkupBuilder;
import java.util.UUID;

//This is the folder in KeePass where the passwords will be imported to, 
//it will be created if it doesn't already exist
def DEFAULT_GROUP = "Firefox Imported";

//need to specify both in- and outfile
if (this.args.length != 2) {
  println("");
  println("Usage: groovy ConvertFirefoxPasswords.groovy <infile> <outfile>");
  println("");
  println("Where: ");
  println("       infile  - XML file exported from firefox using plugin at https://addons.mozilla.org/firefox/2848/");
  println("       outfile - XML file to write to, this file can then be imported in KeePass using ");
  println("                 File -> Import From -> Import Keepass XML   ");
  println("");
  println("");
  
  System.exit(1);
}

//create file objects and check that infile is readable
def inFile = new File(this.args[0]);
def outFile = new File(this.args[1]);
if (!inFile.exists() || !inFile.canRead()) {
  println("Unable to read file '${inFile}'");
  System.exit(1);
}

//Groovy handles reading/writing markup beautifully...
//Walk trough each of the entries in the Firefox export and create KeePass
//format output
def inXml  = new groovy.util.XmlParser().parseText(inFile.getText());
def markup = new groovy.xml.MarkupBuilder(new FileWriter(outFile));
markup.pwlist {
  inXml.entries.entry.each() { inEntry ->
    pwentry {
      group(DEFAULT_GROUP)
      title(inEntry["@host"] + " | " + inEntry["@user"])
      username(inEntry["@user"])
      url(inEntry["@host"])
      password(inEntry["@password"])
      //create a random UUID to fake a KeePass UUID...there IS an infinitesimal (yea, that means 
      //REALLY small) chance that this fails :). If so, re-run the conversion...
      uuid(UUID.randomUUID().toString().replace('-', ''))
    }
  }
}

println("");
println("    --> Converted file saved at: '${outFile.getCanonicalPath()}'");
println("");

System.exit(0);
