'----------------------------------------------------------------------
' Format Firefox XML to KeePass XML 16/6/2006 by Paul
'
'----------------------------------------------------------------------
On Error Resume Next

Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")

If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Firefox XML export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\FFexport.xml"
	strTitle = "KeePass XML File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.xml"
		strTemplate=left(strFileName,Len(strFileName)-4) & ".kp.xsl"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Firefox XML export to KeePass XML format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.xml"
		strTemplate=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.xsl"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If

strPrefix="<?xml version=""1.0""?>" & vbCrLf & "<?xml-stylesheet type=""text/xsl"" href=""" & strTemplate & """?>" & vbCrLf
strPos=1
strBegin=InStr(strPos, strData, "<entries", vbTextCompare)
strEnd=InStr(strPos, strData, "</entries>", vbTextCompare)+Len("</entries>")
strOutput=strPrefix & Mid(strData, strBegin, strEnd-strBegin)
set F = FS.OpenTextFile(strOutFile, 2, True)
F.Write strOutput
F.Close
Set F = Nothing
'Set FS = Nothing

strOutput="<?xml version=""1.0"" encoding=""UTF-8""?>" _
	& vbCrLf & "<xsl:stylesheet xmlns:xsl=""http://www.w3.org/1999/XSL/Transform"" xmlns:msxsl=""urn:schemas-microsoft-com:xslt"" xmlns:grunt=""http://www.grunt.tv"" exclude-result-prefixes=""msxsl grunt"" version=""1.0"">" _
	& vbCrLf _
	& "<msxsl:script language=""JScript"" implements-prefix=""grunt"">" _
	& vbCrLf & "<![CDATA[" _
	& vbCrLf _
	& "function randHex()" _
	& vbCrLf & "{" _
	& vbCrLf & "var v = Math.round(Math.random() * 15);" _
	& vbCrLf & "switch(v)" _
	& vbCrLf & "{" _
	& vbCrLf & "case 15: return ""f"";" _
	& vbCrLf & "case 14: return ""e"";" _
	& vbCrLf & "case 13: return ""d"";" _
	& vbCrLf & "case 12: return ""c"";" _
	& vbCrLf & "case 11: return ""b"";" _
	& vbCrLf & "case 10: return ""a"";" _
	& vbCrLf & "default: return String(v);" _
	& vbCrLf & "}" _
	& vbCrLf & "}" _
	& vbCrLf & "function getUuid()" _
	& vbCrLf & "{" _
	& vbCrLf & "var uuid;" _
	& vbCrLf & "uuid = """";" _
	& vbCrLf & "for(var i =0;i<32;i++)" _
	& vbCrLf & "{" _
	& vbCrLf & "uuid += randHex();" _
	& vbCrLf & "}" _
	& vbCrLf & "return uuid;" _
	& vbCrLf & "}" _
	& vbCrLf & "]]>" _
	& vbCrLf & "</msxsl:script>" _
	& vbCrLf _
	& vbCrLf & "	<xsl:template match=""/"">" _
	& vbCrLf & "		<TABLE>" _
	& vbCrLf & "		<TR><TH colspan=""2"">Copy the data below this line and save it to a file (FFimport.xml), then import it into KeePass</TH></TR>" _
	& vbCrLf & "		<TR><TD>&lt;?xml version=""1.0"" encoding=""UTF-8""?&gt;</TD></TR>" _
	& vbCrLf & "		<TR><TD>&lt;pwlist&gt;</TD></TR>" _
	& vbCrLf & "		<xsl:for-each select=""entries/entry"">" _
	& vbCrLf & "			<TR><TD>&lt;pwentry&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;group tree=""General""&gt;FireFox&lt;/group&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;title&gt;<xsl:value-of select=""@host""/>&lt;/title&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;username&gt;<xsl:value-of select=""@user""/>&lt;/username&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;url&gt;<xsl:value-of select=""@host""/>&lt;/url&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;password&gt;<xsl:value-of select=""@password""/>&lt;/password&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;notes&gt;userFieldName=<xsl:value-of select=""@userFieldName""/></TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>passFieldName=<xsl:value-of select=""@passFieldName""/>&lt;/notes&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;uuid&gt;<xsl:value-of select=""grunt:getUuid()""/>&lt;/uuid&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;image&gt;1&lt;/image&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;creationtime&gt;2007-05-21T15:02:52&lt;/creationtime&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;lastmodtime&gt;2007-05-21T15:02:52&lt;/lastmodtime&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;lastaccesstime&gt;2007-05-21T15:02:52&lt;/lastaccesstime&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD></TD><TD>&lt;expiretime expires=""false""&gt;2999-12-28T23:59:59&lt;/expiretime&gt;</TD></TR>" _
	& vbCrLf & "			<TR><TD>&lt;/pwentry&gt;</TD></TR>" _
	& vbCrLf & "		</xsl:for-each>" _
	& vbCrLf & "		<TR><TD>&lt;/pwlist&gt;</TD></TR>" _
	& vbCrLf & "		</TABLE>" _
	& vbCrLf & "	</xsl:template>" _
	& vbCrLf & "</xsl:stylesheet>"
set F = FS.OpenTextFile(strTemplate, 2, True)
F.Write strOutput
F.Close
Set F = Nothing
Set FS = Nothing

'wscript.quit    
'Wscript.echo "Data converted to KeePass CSV format - " & strOutFile

Dim objIE: Set objIE = WScript.CreateObject ("InternetExplorer.Application")
objIE.Navigate "file://" & strOutfile
objIE.Visible = True
Set objIE = Nothing
wscript.quit    


Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
