' Format eWallet text to KeePass CSV 2/04/2007 by Paul
' V2 Windows 98/2000 file input box added 2/6/2007
'
On Error Resume Next
Dim arrKPRecord(4)
strOutput = """Account"",""Login Name"",""Password"",""Web Site"",""Comments""" & vbCrLf

'Open file to be converted.
Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the eWallet export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\PWCexport.txt"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from eWallet export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If

strPos=1
'Look for Category on the first line
strEnd=InStr(strData, vbCrLf)
strFirstLine=Mid(strData, strPos, strEnd-strPos)
If InStr(strFirstLine,"Category:") Then
	strCategory=strFirstLine
End If

Do
	For strCount=0 To 4 'set output array ready for data
		arrKPRecord(strCount)=""
	Next
	If strNextCategory<>"" Then
		strCategory=strNextCategory
	End If

	strPos=InStr(strPos, strData, vbCrLf & "Card Name", vbBinaryCompare) + Len(vbCrLf)
	strEnd=InStr(strPos+1, strData, vbCrLf & "Card Name", vbBinaryCompare)
	If strEnd < 1 Then
		strEnd=Len(strData)
	End If
	strRecord=Mid(strData, strPos, strEnd-strPos-Len(vbCrLf))
	arrRecord=Split(strRecord, vbCrLf)
	For Each strElement In arrRecord 'Collect all data and sort
		If InStr(Left(strElement,10), "Card Name") Then
			arrKPRecord(0)="""" & EscapeChar(Trim(Mid(strElement, 10))) & """"
		ElseIf InStr(Left(strElement,10), "User Name") Then
			arrKPRecord(1)="""" & EscapeChar(Trim(Mid(strElement, 10))) & """"
		ElseIf InStr(Left(strElement,10), "Password") Then
			arrKPRecord(2)="""" & EscapeChar(Trim(Mid(strElement, 9))) & """"
		ElseIf InStr(Left(strElement,4), "URL") Then
			arrKPRecord(3)="""" & EscapeChar(Trim(Mid(strElement, 4))) & """"
		Else
			If InStr(Left(strElement,10), "Category:") Then 'Add Category
				strNextCategory=EscapeChar(strElement)
			Else
				If arrKPRecord(4)="" then
					arrKPRecord(4)="""" & EscapeChar(strElement)
				else
					arrKPRecord(4)=arrKPRecord(4) & vbCrLf & EscapeChar(strElement)
				End If
			End If
		End if
	Next
	For strCount = 0 To 4
		If arrKPRecord(strCount)="" Then
			arrKPRecord(strCount)=""""""
		End If
	Next
	strPos = strEnd
	If strCategory="" then
		arrKPRecord(4)=arrKPRecord(4) & """"
	Else
		arrKPRecord(4)=arrKPRecord(4) & vbCrLf & Trim(strCategory) & """"
	End If
	strOutput = strOutput & Join(arrKPRecord, ",") & vbCrLf
Loop Until InStr(strPos+1, strData, "Card Name", vbBinaryCompare) < 1

'Write the data
set F = FS.OpenTextFile(strOutFile, 2, True)

F.Write strOutput
F.Close
Set FS = Nothing

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile
set WshShell = CreateObject("WScript.Shell")
WshShell.Exec("notepad " & strOutFile)
set WshShell = Nothing

Wscript.quit

Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """", "\""")
End Function

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
