' Format Whisper text to KeePass CSV 21/03/2007 by Paul
' V2 Windows 98/2000 file input box added 2/6/2007
' V3 Fixed character escaping for quotes and backslashes, 8/9/2007
'
On Error Resume Next
Dim arrRecord(4)
strOutput = """Account"",""Login Name"",""Password"",""Web Site"",""Comments"""

'Open file to be converted.
Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Whisper export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\PWCexport.txt"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Whisper export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If


strPos=1
strEnd=InStr(strPos, strData, vbCrLf, vbBinaryCompare)
strHead=Mid(strData, strPos, strEnd-strPos)
arrHead=Split(strHead, ",")
strElements=UBound(arrHead) + 1
strPos=strEnd+Len(vbCrLf)
strElBegin=strPos+1

Do
	For strCount = 0 To strElements - 2	'collect elements in the record
		strElEnd = InStr(strElBegin, strData, """,""", vbBinaryCompare)
		If strCount < 4 then
			If strCount < 3 Then 'add quotes at both ends as element is complete
				arrRecord(strCount) = """" & EscapeChar(mid(strData, strElBegin, strElEnd-strElBegin)) & """"
			Else
				'Leave a space for the web address record
				'First Memo element, add a quote to the front
				arrRecord(strCount+1) = """" & EscapeChar(mid(strData, strElBegin, strElEnd-strElBegin))
			End if
		Else
			'Add to Memo field, no quotes added
			arrRecord(4) = arrRecord(4) & vbCrLf & Mid(arrHead(strCount),2,Len(arrHead(strCount))-2) & ": " & EscapeChar(mid(strData, strElBegin, strElEnd-strElBegin))
		End if
		strElBegin = strElEnd + Len(""",""")
		
	Next
	strElEnd=InStr(strElBegin, strData, vbCrLf, vbBinaryCompare)-1
	'Last Memo element, remove quote at end of original data, escape chars then add quote.
	arrRecord(4) = arrRecord(4) & vbCrLf & Mid(arrHead(UBound(arrHead)),2,Len(arrHead(strCount))-2) & ": " & EscapeChar(mid(strData, strElBegin, strElEnd-strElBegin)) & """"
	arrRecord(3) = """"""
	strOutput = strOutput & vbCrLf & Join(arrRecord, ",")

	strElBegin = strElEnd + Len(vbCrLf) + 2

Loop Until InStr(strElBegin, strData, """,""", vbBinaryCompare) < 1


'Write the data
set F = FS.OpenTextFile(strOutFile, 2, True)

F.Write strOutput
F.Close
Set FS = Nothing

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile
set WshShell = CreateObject("WScript.Shell")
WshShell.Exec("notepad " & strOutFile)
set WshShell = Nothing

Wscript.quit

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function

Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "<Newline>", vbCrLf)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """""", "\""") 'Special replace for Whisper, replaces 2 quotes
End Function
