'----------------------------------------------------------------------
' Format Roboform HTML export to KeePass CSV 19/06/2006 by Paul
'
'On Error Resume Next
Dim strOutput, constDelim
strOutput="""Account"",""Login Name"",""Password"",""Web Site"",""Comments""" & vbCrLf

Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Roboform HTML export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\Roboform.html"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Roboform HTML export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If

'Remove <WBR> codes
strData=Replace(strData, "<WBR>", "")
bLastEntry=False
strEntryBegin=1

Do
	strEntryBegin=InStr(strEntryBegin, strData, "class=caption", vbTextCompare)
	strEntryEnd=InStr(strEntryBegin+1, strData, "class=caption", vbTextCompare)
	If strEntryEnd=0 Then
		strEntryEnd=Len(strData)
		bLastEntry=True
	End If
On Error Resume Next
	arrData=GetClass(Mid(strData, strEntryBegin, strEntryEnd-strEntryBegin))
If Err.number <> 0 Then
wscript.echo strEntryBegin, strEntryEnd, Len(strData) & vbCrLf & Err.description & vbCrLf & strOutput
wscript.quit
End If
	count=0
	For Each strRecord In arrData
		arrTest=Split(strRecord, "=")
		Select Case count
		Case 1
			strTitle=EscapeChar(arrTest(1))
		Case 2
			strURL="http://" & EscapeChar(arrTest(1))
		Case 3
			'Heading only, do nothing
		Case 4
			strUser=EscapeChar(arrTest(1))
		Case 5
			'Heading only, do nothing
		Case 6
			strPass=EscapeChar(arrTest(1))
		Case 7
			strNote=EscapeChar(arrTest(1))
		Case 8
			strNote=strNote & " = " & EscapeChar(arrTest(1))
		Case 9
			strNote=strNote & vbCrLf & EscapeChar(arrTest(1))
		Case 10
			strNote=strNote & " = " & EscapeChar(arrTest(1))
		End Select
		count=count+1
	Next
	'Join em up.
	strOutput=strOutput & """" & strTitle & """,""" & strURL & """,""" & strUser & """,""" & strPass & """,""" & strNote & """" & vbCrLf
	
	strEntryBegin=strEntryEnd
Loop Until bLastEntry

'AddData
'wscript.echo strOutput
'wscript.echo strOutFile

set F = FS.OpenTextFile(strOutFile, 2, True)
F.Write strOutput
F.Close
Set FS = Nothing

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile

set WshShell = WScript.CreateObject("WScript.Shell")
WshShell.Exec("notepad " & strOutFile)
set WshShell = Nothing

wscript.quit    
    
Function GetClass(strRecord)
'Split into Class and Data
	Dim arrFData()
	strBegin=1
	fcount=0
	Do
		fcount=fcount + 1
		strBegin=InStr(strBegin, strRecord, "class=", vbTextCompare)+Len("class=")
		strEnd=InStr(strBegin, strRecord, " ", vbTextCompare)
		strClass=Mid(strRecord, strBegin, strEnd-strBegin)
		strBegin=InStr(strBegin, strRecord, ">", vbTextCompare)+1
		strEnd=InStr(strBegin, strRecord, "<", vbTextCompare)
		strVal=Mid(strRecord, strBegin, strEnd-strBegin)
		ReDim preserve arrFData(fcount)
		arrFData(fcount)=strClass & "=" & strVal
		strBegin=strEnd
	Loop Until InStr(strBegin, strRecord, "class=", vbTextCompare)=0
	GetClass=arrFData
End Function
    
'File function
Function GetFile()
	Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo Error: File Not opened
		Wscript.quit
	Else
'		Wscript.Echo objDlg.FileName
		strOutFile strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		GetFile = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End Function

Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "<Newline>", vbCrLf)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """", "\""")
End Function

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
