' Format PassReminder text to KeePass CSV 10/6/2007 by Paul
'
On Error Resume Next
Dim arrRecord(4)
strOutput = """Account"",""Login Name"",""Password"",""Web Site"",""Comments""" & vbCrLf

'Open file to be converted.
Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Whisper export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\PWCexport.txt"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Whisper export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If


strPos=1
strEnd=InStr(strPos, strData, vbCrLf, vbBinaryCompare)
strHead=Mid(strData, strPos, strEnd-strPos)
If InStr(strHead, """") = 0 Then 'jump over the first line if it's a header
	strPos=strEnd + Len(vbCrLf)
End If

Do
	strEnd = InStr(strPos, strData, """" & vbCrLf, vbBinaryCompare) + 1
	strTmp = """;" & Mid(strData, strPos, strEnd-strPos) & ";"""
	arrTmp = Split(strTmp, """;""")
	For strCount = 5 To 10	'collect elements in the record
		If strCount < 9 Then
			arrRecord(strCount - 5) = """" & EscapeChar(arrTmp(strCount)) & """"
		Else
			If strCount = 9 Then ' mail address
				arrRecord(strCount - 5) = """Mail: " & EscapeChar(arrTmp(strCount)) & vbCrLf
			Else
				arrRecord(strCount - 6) = arrRecord(strCount - 6) & EscapeChar(arrTmp(strCount)) & """"
			End If
		End If
	Next 
	strOutput = strOutput & Join(arrRecord, ",")

	strPos = strEnd + Len(vbCrLF)

Loop Until InStr(strPos, strData, """;""", vbBinaryCompare) < 1


'Write the data
set F = FS.OpenTextFile(strOutFile, 2, True)

F.Write strOutput
F.Close
Set FS = Nothing

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile
set WshShell = CreateObject("WScript.Shell")
WshShell.Exec("notepad " & strOutFile)
set WshShell = Nothing

Wscript.quit

Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "<Newline>", vbCrLf)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """", "\""")
End Function

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
