'----------------------------------------------------------------------
' Format Password Coral to KeePass CSV 19/01/2006 by Paul
' V2 Windows 98/2000 file input box added 2/6/2007
'
On Error Resume Next
Dim strOutput, constDelim
strOutput="""Account"",""Login Name"",""Password"",""Web Site"",""Comments"""
constDelim="----------------------------------------------------------------------"

Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Password Coral export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\PWCexport.txt"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Password Coral export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If

strPos=1
Do
	strEnd=InStr(strPos, strData, vbCrLf, vbTextCompare)+Len(vbCrLf)
	If strEnd>Len(vbCrLf) Then 'data to be picked up
		strLine=mid(strData, strPos, strEnd-strPos)
		If InStr(strLine, constDelim) Then
			AddData
		Else
			strRec=strRec & strLine
		End if

	End if
	If strEnd=Len(vbCrLf) Then Exit do
	strPos=strEnd 
Loop
AddData
'wscript.echo strOutput
'wscript.echo strOutFile

set F = FS.OpenTextFile(strOutFile, 2, True)
F.Write strOutput
F.Close
Set FS = Nothing

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile

set WshShell = WScript.CreateObject("WScript.Shell")
WshShell.Exec("notepad " & strOutFile)
set WshShell = Nothing

wscript.quit    
    
    
Function AddData()
	If strRec<>"" Then 'break into array and add to output
		arrRec=Split(strRec, vbCrLf)
		For strx=0 To UBound(arrRec)-1
			If strx=0 Then arrRec(0)="""" & EscapeChar(arrRec(0)) End if
			If strx=1 Then arrRec(1)= """,""" & EscapeChar(arrRec(1)) End if
			If strx=2 Then arrRec(2)= """,""" & EscapeChar(arrRec(2)) End if
			If strx=3 Then arrRec(3)= """,""" & EscapeChar(arrRec(3)) End if
			If strx=4 Then arrRec(4)= """,""" & EscapeChar(arrRec(4)) End if
			If strx>4 Then
				If arrRec(strx)<>"" Then arrRec(strx)= vbCrLf & EscapeChar(arrRec(strx)) 
			End if
		Next
		strOutput=strOutput & vbCrLf & Join(arrRec, "") & """"
		If UBound(arrRec)<5 Then
			For stry=UBound(arrRec) To 5
				strOutput=strOutput & ","""
			Next
		End if
	End if
	strRec=""
End Function
    

'File function
Function GetFile()
	Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo Error: File Not opened
		Wscript.quit
	Else
'		Wscript.Echo objDlg.FileName
		strOutFile strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		GetFile = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End Function

Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "<Newline>", vbCrLf)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """", "\""")
End Function

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
