' Format Access Manager text to KeePass CSV 10/04/2007 by Paul
' V2 Windows 98/2000 file input box added 2/6/2007
'
'On Error Resume Next
Dim arrKPRecord(4)
strOutput = """Account"",""Login Name"",""Password"",""Web Site"",""Comments""" & vbCrLf

'Open file to be converted.
Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Access Manager export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\PWCexport.txt"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
		strBadOutFile=left(strFileName,Len(strFileName)-4) & ".kp.log"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Access Manager export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strBadOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.log"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If

LineOne=1
arrData=Split(strData, vbCrLf)
For Each strRecord In arrData 'Collect all data and sort
	If LineOne=1 Then 'collect number of fields and names
		arrHeader=Split(strRecord, ",")
		intNumFields=UBound(arrHeader) 'counts from 0
		For count=0 To intNumFields
			arrHeader(count)=Replace(arrHeader(count), """", "")
			If InStr(arrHeader(count), "Description") Then
				constDesc=count
			ElseIf InStr(arrHeader(count), "Username") Then
				constUser=count
			ElseIf InStr(arrHeader(count), "Password") Then
				constPass=count
			End If 
		Next
		LineOne=0
	Else 'collect data
		strRecord=Replace(strRecord, """,""", """#RecDelim#""", 1)
		arrRecord=Split(strRecord, "#RecDelim#")
		If UBound(arrRecord) > intNumFields Or UBound(arrRecord) < 1 Then 'bad field delimeters
			'save data for manual conversion
			strBadData=strBadData & Join(arrRecord, ",") & vbCrLf
		Else
			count=0
			arrKPRecord(3)=""""""
			arrKPRecord(4)=""""
			For Each strField In arrRecord
				'should start and end with a quote
				strField=Trim(strField)
				strField=Mid(strField, 2, Len(strField)-2)
				'need to know which field, i.e. Title, User, Pass
				If count=constDesc Then
					arrKPRecord(0)="""" & EscapeChar(strField) & """"
				ElseIf count=constUser Then
					arrKPRecord(1)="""" & EscapeChar(strField) & """"
				ElseIf count=constPass Then
					arrKPRecord(2)="""" & EscapeChar(strField) & """"
				ElseIf InStr(strField, "http://") Then 
					arrKPRecord(3)="""" & EscapeChar(strField) & """"
				Else 'prepend category 
					arrKPRecord(4)=arrKPRecord(4) & EscapeChar(arrHeader(count)) & ": " & EscapeChar(strField) & vbCrLf
				End If
				count=count+1
			Next
			'clean up end of Notes field
			arrKPRecord(4)=Left(arrKPRecord(4), Len(arrKPRecord(4)) - Len(vbCrLf)) & """"
			strOutput = strOutput & Join(arrKPRecord, ",") & vbCrLf
		End If
	End If

Next

'Write the data
set F = FS.OpenTextFile(strOutFile, 2, True)
F.Write strOutput
F.Close

set WshShell = CreateObject("WScript.Shell")
If strBadData <> "" then
	set F = FS.OpenTextFile(strBadOutFile, 2, True)
	F.Write strBadData
	F.Close
	Wscript.echo "Invalid Data has been separated from converted KeePass data" & vbCrLf & "Invalid Data saved to " & strBadOutFile
	WshShell.Exec("notepad " & strBadOutFile)
End If

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile
WshShell.Exec("notepad " & strOutFile)

set WshShell = Nothing
Set FS = Nothing

Wscript.quit

Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "<Newline>", vbCrLf)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """", "\""")
End Function

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
