' ConvertAccessMan modified for Passwords Plus by Gil: Export as CSV from Passwords Plus and run this script
' Categories are completely ignored
'
' Format Access Manager text to KeePass CSV 10/04/2007 by Paul
' V2 Windows 98/2000 file input box added 2/6/2007
'
'On Error Resume Next
strOutput = """Account"",""Login Name"",""Password"",""Web Site"",""Comments""" & vbCrLf

'Open file to be converted.
Dim FS: Set FS = CreateObject("Scripting.FileSystemObject")
If GetVer <> "5.1" Then 'Windows 2000 or earlier, or Vista
	strMessage = "Enter the full filename of the Access Manager export" & vbCrLf
	strMessage = strMessage & "e.g. C:\Temp\PWCexport.txt"
	strTitle = "KeePass text to CSV File Converter"
	strFileName = InputBox(strMessage,strTitle)
	strData = FS.OpenTextFile(strFileName).ReadAll
	If Err Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
		strOutFile=left(strFileName,Len(strFileName)-4) & ".kp.csv"
		strBadOutFile=left(strFileName,Len(strFileName)-4) & ".kp.log"
	End If
Else 'Windows XP
	Wscript.echo "Select file to convert from Access Manager export to KeePass CSV format"
	Dim objDlg:	Set objDlg = CreateObject("UserAccounts.CommonDialog")
	'	objDlg.InitialDir = "D:\Temp"
	intResult = objDlg.ShowOpen

	If intResult = 0 Then
		Wscript.echo "Error: File Not opened"
		Wscript.quit
	Else
	'		Wscript.Echo objDlg.FileName
		strOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.csv"
		strBadOutFile=left(objDlg.FileName,Len(objDlg.FileName)-4) & ".kp.log"
		strData = FS.OpenTextFile(objDlg.FileName).ReadAll
	End If
End If

' Remove Header Lines
strD2 = ""
arrD=Split(strData, vbCrLf)
linenum=1
For Each strRecord in arrD
    if linenum > 2 Then
        strD2 = strD2 & strRecord & vbCrLf
    End If
    linenum = linenum+1
Next

' Use RegEx to separate records
StringToSearch = strD2
Set RegularExpressionObject = New RegExp
With RegularExpressionObject
.Pattern = "((?:[^"",\r]|(?:""(?:\\{2}|\\""|[^""])*?""))*)"
.IgnoreCase = True
.Global = True
.MultiLine = False
End With

Set expressionmatch = RegularExpressionObject.Execute(StringToSearch)

If expressionmatch.Count = 0 Then
    strOutput = strOutput & "ERROR: NO RECORDS FOUND" & vbCrLf
End If

' Iterate through all regex matches. Every 34 matches is one record
' After the first match, before every valid match is an empty match
Dim arrRec(33)
lastrec = ""
idx = 0
For Each expressionmatched in expressionmatch
    If lastrec = "" Then ' skip empty match
        arrRec(idx) = Replace(expressionmatched.Value, """", "")
        idx = idx+1
    End If
    
    If idx > 33 Then ' next record
        strOutput = strOutput & ConvertRec(arrRec) & vbCrLf
        idx = 0
    End If
    
    lastrec = expressionmatched.Value
Next


Set RegularExpressionObject = nothing


'Write the data
set F = FS.OpenTextFile(strOutFile, 2, True)
F.Write strOutput
F.Close

set WshShell = CreateObject("WScript.Shell")
If strBadData <> "" then
	set F = FS.OpenTextFile(strBadOutFile, 2, True)
	F.Write strBadData
	F.Close
	Wscript.echo "Invalid Data has been separated from converted KeePass data" & vbCrLf & "Invalid Data saved to " & strBadOutFile
	WshShell.Exec("notepad " & strBadOutFile)
End If

Wscript.echo "Data converted to KeePass CSV format - " & strOutFile
WshShell.Exec("notepad " & strOutFile)

set WshShell = Nothing
Set FS = Nothing

Wscript.quit

' Generate a line for PK from arr of one PP line
Function ConvertRec(arr)
    '0:"Account",1:"Login Name",2:"Password",3:"Web Site",4:"Comments"
    Dim arrPK(4)
    
    arrPK(0) = EscapeChar(arr(1))
    arrPK(1) = ""
    arrPK(2) = ""
    arrPK(3) = ""
    arrPK(4) = EscapeChar(arr(33))
    
    xnotes = ""
    
    For idx =  0 to 9
        realidx = 3+idx*3
        sfieldname = lcase(arr(realidx))
        
        ' Username
        If (arrPK(1)= "") And (sfieldname = "username" Or sfieldname = "userid" Or sfieldname = "user id" Or sfieldname = "user name" Or sfieldname = "login" Or sfieldname = "logon" Or sfieldname = "email" or sfieldname = "e-mail") Then
            arrPK(1) = EscapeChar(arr(realidx+1))
        ' Password
        ElseIf (arrPK(2) = "") And (sfieldname = "password" or sfieldname = "online password" or sfieldname = "pw" OR sfieldname = "web pw") Then
            arrPK(2) = EscapeChar(arr(realidx+1))
        ' Website
        ElseIf (arrPK(3) = "") And (sfieldname = "website" or sfieldname = "www" or sfieldname = "url") Then
            arrPK(3) = EscapeChar(arr(realidx+1))
        ElseIf arr(realidx+1) <> "" Then
            xnotes = xnotes & EscapeChar(arr(realidx)) & ": " & EscapeChar(arr(realidx+1)) & vbCrLf
        End If
    Next
    
    if xnotes <> "" Then
        arrPK(4) = xnotes & "---" & vbCrLf & arrPK(4)
    End If
    
    For i = 0 to 4
        arrPK(i) = """" & arrPK(i) & """"
    Next
    ConvertRec = Join(arrPK, ",")
End Function


Function EscapeChar(strFuncData)
	strFuncData=Replace(strFuncData, "<Newline>", vbCrLf)
	strFuncData=Replace(strFuncData, "\", "\\")
	EscapeChar=Replace(strFuncData, """", "\""")
End Function

Function GetVer
	'Get Windows Version
	Set WshShell = CreateObject("WScript.Shell")
	strOS = WshShell.ExpandEnvironmentStrings("%OS%")
	If strOS="Windows_NT" Then
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "CurrentVersion") & "." & WshShell.regread(strVerkey & "CurrentBuildNumber"),3)
	Else
		strVerKey="HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\"
		GetVer=Left(WshShell.regread(strVerKey & "VersionNumber"),3)
	End if

	'Cleanup
	set WshShell=nothing
End Function
